"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadMappingFile = exports.loadManifestFile = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const manifestEntryPath = 'manifest.json';
const mappingsEntryPath = 'mappings.json';
const loadManifestFile = async archive => {
  return await parseEntryContent(manifestEntryPath, archive);
};
exports.loadManifestFile = loadManifestFile;
const loadMappingFile = async archive => {
  return await parseEntryContent(mappingsEntryPath, archive);
};
exports.loadMappingFile = loadMappingFile;
const parseEntryContent = async (entryPath, archive) => {
  if (!archive.hasEntry(entryPath)) {
    throw new Error(`Could not load archive file: "${entryPath}" not found in archive`);
  }
  try {
    const buffer = await archive.getEntryContent(entryPath);
    return JSON.parse(buffer.toString('utf-8'));
  } catch (e) {
    throw new Error(`Could not parse archive file: ${e}`);
  }
};