"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobs = jobs;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isLoading: false,
  byId: {},
  allIds: []
};
function mapJobsToIds(jobs) {
  const jobsById = {};
  jobs.forEach(job => {
    jobsById[job.id] = job;
  });
  return jobsById;
}
function getJobsIds(jobs) {
  return jobs.map(job => job.id);
}
function jobs(state = initialState, action) {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case _action_types.LOAD_JOBS_START:
      return {
        ...state,
        isLoading: true
      };
    case _action_types.LOAD_JOBS_SUCCESS:
      return {
        byId: mapJobsToIds(payload.jobs),
        allIds: getJobsIds(payload.jobs),
        isLoading: false
      };
    case _action_types.REFRESH_JOBS_SUCCESS:
      return {
        byId: mapJobsToIds(payload.jobs),
        allIds: getJobsIds(payload.jobs)
      };
    case _action_types.LOAD_JOBS_FAILURE:
      return {
        ...state,
        isLoading: false,
        jobLoadError: payload.error
      };
    case _action_types.CREATE_JOB_SUCCESS:
      const {
        job
      } = payload;
      return {
        byId: {
          ...state.byId,
          [job.id]: job
        },
        allIds: state.allIds.concat(job.id)
      };
    default:
      return state;
  }
}