"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGenerationRoutesPublic = registerGenerationRoutesPublic;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _reportingCommon = require("@kbn/reporting-common");
var _common = require("../common");
var _request_handler = require("../common/request_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerGenerationRoutesPublic(reporting, logger) {
  const setupDeps = reporting.getPluginSetupDeps();
  const {
    router
  } = setupDeps;
  const kibanaAccessControlTags = ['generateReport'];
  const registerPublicPostGenerationEndpoint = () => {
    const path = `${_reportingCommon.PUBLIC_ROUTES.GENERATE_PREFIX}/{exportType}`;
    router.post({
      path,
      security: {
        authz: {
          requiredPrivileges: kibanaAccessControlTags
        }
      },
      validate: _request_handler.GenerateRequestHandler.getValidation(),
      options: {
        tags: kibanaAccessControlTags.map(controlAccessTag => `access:${controlAccessTag}`),
        access: 'public'
      }
    }, (0, _common.authorizedUserPreRouting)(reporting, async (user, context, req, res) => {
      try {
        const requestHandler = new _request_handler.GenerateRequestHandler({
          reporting,
          user,
          context,
          path,
          req,
          res,
          logger
        });
        return await requestHandler.handleRequest({
          exportTypeId: req.params.exportType,
          jobParams: requestHandler.getJobParams()
        });
      } catch (err) {
        if (err instanceof _coreHttpRouterServerInternal.KibanaResponse) {
          return err;
        }
        throw err;
      }
    }));
  };
  const registerPublicGetGenerationEndpoint = () => {
    // Get route to generation endpoint: show error about GET method to user
    router.get({
      path: `${_reportingCommon.PUBLIC_ROUTES.GENERATE_PREFIX}/{p*}`,
      security: {
        authz: {
          enabled: false,
          reason: 'This route is opted out from authorization'
        }
      },
      validate: false,
      options: {
        access: 'public'
      }
    }, (_context, _req, res) => {
      return res.customError({
        statusCode: 405,
        body: 'GET is not allowed'
      });
    });
  };
  registerPublicPostGenerationEndpoint();
  registerPublicGetGenerationEndpoint();
}