"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.supportedReportTypes = exports.getReportParams = void 0;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _get_png_pdf_job_params = require("@kbn/reporting-public/share/shared/get_png_pdf_job_params");
var _csv_export_config = require("@kbn/reporting-public/share/integrations/csv/csv_export_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reportParamsProviders = {
  pngV2: _get_png_pdf_job_params.getPngReportParams,
  printablePdfV2: _get_png_pdf_job_params.getPdfReportParams,
  csv_searchsource: _csv_export_config.getCsvReportParams,
  csv_v2: _csv_export_config.getCsvReportParams
};
const supportedReportTypes = exports.supportedReportTypes = Object.keys(reportParamsProviders);
const getReportParams = ({
  apiClient,
  reportTypeId,
  objectType,
  sharingData,
  title
}) => {
  const getParams = reportParamsProviders[reportTypeId];
  if (!getParams) {
    throw new Error(`No params provider found for report type ${reportTypeId}`);
  }
  return _rison.default.encode(apiClient.getDecoratedJobParams({
    ...getParams({
      objectType,
      sharingData
    }),
    objectType,
    title
  }));
};
exports.getReportParams = getReportParams;