"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportDestructiveActionConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/report_destructive_action_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_CONFIRM_BUTTON_TEXT = _i18n.i18n.translate('xpack.reporting.schedules.destructiveAction.confirm', {
  defaultMessage: 'Confirm'
});
const ReportDestructiveActionConfirmationModalComponent = ({
  title,
  message,
  onCancel,
  onConfirm,
  confirmButtonText = DEFAULT_CONFIRM_BUTTON_TEXT
}) => {
  const titleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    cancelButtonText: _i18n.i18n.translate('xpack.reporting.schedules.destructiveAction.cancel', {
      defaultMessage: 'Cancel'
    }),
    "data-test-subj": "confirm-destructive-action-modal",
    defaultFocusedButton: "confirm",
    onCancel: onCancel,
    onConfirm: onConfirm,
    title: title,
    titleProps: {
      id: titleId
    },
    confirmButtonText: confirmButtonText,
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, message);
};
ReportDestructiveActionConfirmationModalComponent.displayName = 'DisableReportConfirmationModal';
const ReportDestructiveActionConfirmationModal = exports.ReportDestructiveActionConfirmationModal = /*#__PURE__*/_react.default.memo(ReportDestructiveActionConfirmationModalComponent);