"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterEdit = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _shared_imports = require("../../../shared_imports");
var _services = require("../../services");
var _breadcrumb = require("../../services/breadcrumb");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/remote_cluster_edit/remote_cluster_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FORM_MAX_WIDTH = 850;
const RemoteClusterEdit = ({
  isLoading,
  cluster,
  startEditingCluster,
  stopEditingCluster,
  editCluster,
  isEditingCluster,
  getEditClusterError,
  clearEditClusterErrors,
  openDetailPanel
}) => {
  const match = (0, _reactRouterDom.useRouteMatch)();
  const {
    name: clusterName
  } = match.params;
  const {
    history,
    route: {
      location: {
        search
      }
    }
  } = (0, _services.getRouter)();
  (0, _react.useEffect)(() => {
    (0, _breadcrumb.setBreadcrumbs)('edit', `?cluster=${clusterName}`);
    startEditingCluster(clusterName);
    return () => {
      clearEditClusterErrors();
      stopEditingCluster();
    };
  }, [clusterName, startEditingCluster, clearEditClusterErrors, stopEditingCluster]);
  const cancel = () => {
    const {
      redirect: redirectUrl
    } = (0, _shared_imports.extractQueryParams)(search);
    if (redirectUrl && typeof redirectUrl === 'string') {
      const decodedRedirect = decodeURIComponent(redirectUrl);
      (0, _services.redirect)(decodedRedirect);
    } else {
      history.push('/list');
      openDetailPanel(clusterName);
    }
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.edit.loadingLabel",
      defaultMessage: "Loading remote cluster\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }));
  }
  if (!cluster) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "warning",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.edit.loadingErrorTitle",
        defaultMessage: "Error loading remote cluster",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.edit.loadingErrorMessage",
        defaultMessage: "The remote cluster ''{name}'' does not exist.",
        values: {
          name: clusterName
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 13
        }
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, '/list'), {
        color: "danger",
        iconType: "arrowLeft",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.edit.viewRemoteClustersButtonLabel",
        defaultMessage: "View remote clusters",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    });
  }
  const {
    hasDeprecatedProxySetting
  } = cluster;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: true,
    "data-test-subj": "remote-clusters-edit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: FORM_MAX_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.RemoteClusterPageTitle, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.editTitle",
      defaultMessage: "Edit remote cluster",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }), hasDeprecatedProxySetting ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: false,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.edit.deprecatedSettingsTitle",
      defaultMessage: "Proceed with caution",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 17
      }
    }),
    color: "warning",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.edit.deprecatedSettingsMessage",
    defaultMessage: "This remote cluster has deprecated settings that we tried to resolve. Verify all changes before saving.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_components.RemoteClusterForm, {
    cluster: cluster,
    isSaving: isEditingCluster,
    saveError: getEditClusterError,
    confirmFormAction: editCluster,
    onBack: cancel,
    confirmFormText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.edit.save",
      defaultMessage: "Save",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 13
      }
    }),
    backFormText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  })));
};
exports.RemoteClusterEdit = RemoteClusterEdit;