"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DistinctProbabilisticValuesWarning = DistinctProbabilisticValuesWarning;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/storage_explorer/distinct_probabilistic_values_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DistinctProbabilisticValuesWarning({
  totalNumberOfDistinctProbabilisticValues
}) {
  const {
    docLinks
  } = (0, _use_profiling_dependencies.useProfilingDependencies)().start.core;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.profiling.storageExplorer.distinctProbabilisticProfilingValues.title', {
      defaultMessage: "We've identified {count} distinct probabilistic profiling values. Make sure to update them.",
      values: {
        count: totalNumberOfDistinctProbabilisticValues
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.distinctProbabilisticProfilingValues.description', {
    defaultMessage: 'We recommend using a consistent probabilistic value for each project for more efficient storage, cost management, and to maintain good statistical accuracy.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "profilingDistinctProbabilisticValuesWarningLearnHowButton",
    href: `${docLinks.ELASTIC_WEBSITE_URL}/guide/en/observability/${docLinks.DOC_LINK_VERSION}/profiling-probabilistic-profiling.html`,
    color: "warning",
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.distinctProbabilisticProfilingValues.button', {
    defaultMessage: 'Learn how'
  })));
}