"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DifferentialFlameGraphsView = DifferentialFlameGraphsView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _common = require("@kbn/observability-plugin/common");
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _flamegraph = require("../../../components/flamegraph");
var _normalization_menu = require("../../../components/normalization_menu");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_route_path = require("../../../hooks/use_profiling_route_path");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
var _differential_flame_graph_search_panel = require("./differential_flame_graph_search_panel");
var _frames_summary = require("../../../components/frames_summary");
var _use_async = require("../../../hooks/use_async");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/flamegraphs/differential_flamegraphs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DifferentialFlameGraphsView() {
  var _state$data2, _state$data3;
  const {
    query,
    query: {
      rangeFrom,
      rangeTo,
      kuery,
      comparisonRangeFrom,
      comparisonRangeTo,
      comparisonKuery,
      comparisonMode,
      baseline = 1,
      comparison = 1,
      normalizationMode,
      searchText
    }
  } = (0, _use_profiling_params.useProfilingParams)('/flamegraphs/differential');
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonTimeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom: comparisonRangeFrom,
    rangeTo: comparisonRangeTo,
    optional: true
  });
  const {
    services: {
      fetchElasticFlamechart
    },
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const showErrorFrames = core.uiSettings.get(_common.profilingShowErrorFrames);
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return Promise.all([fetchElasticFlamechart({
      http,
      timeFrom: new Date(timeRange.start).getTime(),
      timeTo: new Date(timeRange.end).getTime(),
      kuery,
      showErrorFrames
    }), comparisonTimeRange.start && comparisonTimeRange.end ? fetchElasticFlamechart({
      http,
      timeFrom: new Date(comparisonTimeRange.start).getTime(),
      timeTo: new Date(comparisonTimeRange.end).getTime(),
      kuery: comparisonKuery,
      showErrorFrames
    }) : Promise.resolve(undefined)]).then(([primaryFlamegraph, comparisonFlamegraph]) => {
      return {
        primaryFlamegraph,
        comparisonFlamegraph
      };
    });
  }, [fetchElasticFlamechart, timeRange.start, timeRange.end, kuery, comparisonTimeRange.start, comparisonTimeRange.end, comparisonKuery, showErrorFrames]);
  const totalSeconds = timeRange.inSeconds.end - timeRange.inSeconds.start;
  const totalComparisonSeconds = (new Date(comparisonTimeRange.end).getTime() - new Date(comparisonTimeRange.start).getTime()) / 1000;
  const baselineTime = 1;
  const comparisonTime = totalSeconds / totalComparisonSeconds;
  const normalizationOptions = {
    baselineScale: baseline,
    baselineTime,
    comparisonScale: comparison,
    comparisonTime
  };
  const {
    data
  } = state;
  const isNormalizedByTime = normalizationMode === _normalization_menu.NormalizationMode.Time;
  function handleSearchTextChange(newSearchText) {
    // @ts-expect-error Code gets too complicated to satisfy TS constraints
    profilingRouter.push(routePath, {
      query: {
        ...query,
        searchText: newSearchText
      }
    });
  }
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  (0, _react.useEffect)(() => {
    if (state.status === _use_async.AsyncStatus.Settled) {
      var _state$data$primaryFl, _state$data;
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        },
        customMetrics: {
          key1: 'totalSamples',
          value1: (_state$data$primaryFl = (_state$data = state.data) === null || _state$data === void 0 ? void 0 : _state$data.primaryFlamegraph.TotalSamples) !== null && _state$data$primaryFl !== void 0 ? _state$data$primaryFl : 0
        }
      });
    }
  }, [onPageReady, state, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_differential_flame_graph_search_panel.DifferentialFlameGraphSearchPanel, {
    comparisonMode: comparisonMode,
    normalizationMode: normalizationMode,
    normalizationOptions: normalizationOptions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_frames_summary.FramesSummary, {
    isLoading: state.status === _use_async.AsyncStatus.Loading,
    baseValue: (_state$data2 = state.data) !== null && _state$data2 !== void 0 && _state$data2.primaryFlamegraph ? {
      totalCount: state.data.primaryFlamegraph.TotalSamples,
      scaleFactor: isNormalizedByTime ? baselineTime : baseline,
      totalAnnualCO2Kgs: state.data.primaryFlamegraph.TotalAnnualCO2KgsItems[0],
      totalAnnualCostUSD: state.data.primaryFlamegraph.TotalAnnualCostsUSDItems[0]
    } : undefined,
    comparisonValue: (_state$data3 = state.data) !== null && _state$data3 !== void 0 && _state$data3.comparisonFlamegraph ? {
      totalCount: state.data.comparisonFlamegraph.TotalSamples,
      scaleFactor: isNormalizedByTime ? comparisonTime : comparison,
      totalAnnualCO2Kgs: state.data.comparisonFlamegraph.TotalAnnualCO2KgsItems[0],
      totalAnnualCostUSD: state.data.comparisonFlamegraph.TotalAnnualCostsUSDItems[0]
    } : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, state, {
    style: {
      height: '100%'
    },
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_flamegraph.FlameGraph, {
    id: "flamechart",
    primaryFlamegraph: data === null || data === void 0 ? void 0 : data.primaryFlamegraph,
    comparisonFlamegraph: data === null || data === void 0 ? void 0 : data.comparisonFlamegraph,
    comparisonMode: comparisonMode,
    baseline: isNormalizedByTime ? baselineTime : baseline,
    comparison: isNormalizedByTime ? comparisonTime : comparison,
    searchText: searchText,
    onChangeSearchText: handleSearchTextChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }))));
}