"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInterpolationValue = getInterpolationValue;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInterpolationValue(foreground, background, denominator = foreground) {
  if (background === undefined) {
    return 1;
  }
  return (0, _lodash.clamp)((foreground - background) / denominator, -1, 1);
}