"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeEditPanelAction = executeEditPanelAction;
var _triggers = require("../triggers");
var _constants = require("./constants");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function executeEditPanelAction(api) {
  try {
    const action = await _kibana_services.uiActions.getAction(_constants.ACTION_EDIT_PANEL);
    action.execute({
      embeddable: api,
      trigger: {
        id: _triggers.CONTEXT_MENU_TRIGGER
      }
    });
  } catch (error) {
    // eslint-disable-next-line no-console
    console.warn('Unable to execute edit action, Error: ', error.message);
  }
}