"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CpsUsageOverridesBadge = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/ui-actions-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _kibana_services = require("../../kibana_services");
var _constants2 = require("../edit_panel_action/constants");
var _triggers = require("../triggers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/presentation_panel/public/panel_actions/customize_panel_action/cps_usage_overrides_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CpsUsageOverridesBadge {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.CPS_USAGE_OVERRIDES_BADGE);
    (0, _defineProperty2.default)(this, "id", _constants.CPS_USAGE_OVERRIDES_BADGE);
    (0, _defineProperty2.default)(this, "order", 8);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      const {
        embeddable
      } = context;
      const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
      const {
        euiTheme
      } = (0, _eui.useEuiTheme)();
      const overrideValues = this.getOverrideValues(embeddable);
      if (!overrideValues || overrideValues.length === 0) throw new _public.IncompatibleActionError();
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: /*#__PURE__*/_react.default.createElement("button", {
          onClick: () => setIsPopoverOpen(!isPopoverOpen),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 11
          }
        }, strings.badgeLabel),
        isOpen: isPopoverOpen,
        closePopover: () => setIsPopoverOpen(false),
        anchorPosition: "downCenter",
        panelStyle: {
          minWidth: 250
        },
        panelPaddingSize: "none",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        css: {
          padding: euiTheme.size.m
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        css: {
          fontWeight: euiTheme.font.weight.semiBold
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 15
        }
      }, strings.badgeLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: async () => {
          setIsPopoverOpen(false);
          try {
            const action = await _kibana_services.uiActions.getAction(_constants2.ACTION_EDIT_PANEL);
            if (action) {
              await action.execute({
                ...context,
                trigger: {
                  id: _triggers.CONTEXT_MENU_TRIGGER
                }
              });
            }
          } catch (error) {
            _kibana_services.core.notifications.toasts.addError(error, {
              title: strings.error
            });
          }
        },
        size: "xs",
        flush: "right",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 15
        }
      }, strings.editButton))), overrideValues.map((override, index) => /*#__PURE__*/_react.default.createElement("div", {
        key: index,
        css: {
          marginTop: index > 0 ? euiTheme.size.s : 0
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 13
        }
      }, override.name && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        css: {
          marginBottom: euiTheme.size.xs
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 17
        }
      }, override.name), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 15
        }
      }, override.value)))));
    });
  }
  getDisplayName({
    embeddable
  }) {
    const overrideValues = this.getOverrideValues(embeddable);
    if (!overrideValues || overrideValues.length === 0) {
      throw new _public.IncompatibleActionError();
    }
    return strings.displayName;
  }
  async execute(_context) {
    return;
  }
  couldBecomeCompatible({
    embeddable
  }) {
    return (0, _presentationPublishing.apiPublishesProjectRoutingOverrides)(embeddable);
  }
  getCompatibilityChangesSubject({
    embeddable
  }) {
    return (0, _presentationPublishing.apiPublishesProjectRoutingOverrides)(embeddable) ? embeddable.projectRoutingOverrides$.pipe((0, _rxjs.map)(() => undefined)) : undefined;
  }
  getIconType() {
    return 'beaker';
  }
  async isCompatible({
    embeddable
  }) {
    const values = this.getOverrideValues(embeddable);
    return values !== undefined && values.length > 0;
  }
  getOverrideValues(embeddable) {
    if ((0, _presentationPublishing.apiPublishesProjectRoutingOverrides)(embeddable)) {
      return embeddable.projectRoutingOverrides$.getValue();
    }
    return undefined;
  }
}
exports.CpsUsageOverridesBadge = CpsUsageOverridesBadge;
const strings = {
  badgeLabel: _i18n.i18n.translate('presentationPanel.badge.cpsUsageOverrides.label', {
    defaultMessage: 'CPS overrides'
  }),
  displayName: _i18n.i18n.translate('presentationPanel.badge.cpsUsageOverrides.displayName', {
    defaultMessage: 'This panel overrides the CPS scope'
  }),
  editButton: _i18n.i18n.translate('presentationPanel.badge.cpsUsageOverrides.popover.editButton', {
    defaultMessage: 'Edit'
  }),
  error: _i18n.i18n.translate('presentationPanel.badge.cpsUsageOverrides.editError', {
    defaultMessage: 'Failed to open panel configuration'
  })
};