"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConfig = void 0;
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createConfig = context => {
  const pluginConfig = context.config.get();
  const logger = context.logger.get('config');
  const {
    invalid,
    features: experimentalFeatures
  } = (0, _common.parseExperimentalConfigValue)(pluginConfig.enableExperimental);
  if (invalid.length) {
    logger.warn(`Unsupported "xpack.osquery.enableExperimental" values detected.
The following configuration values are not supported and should be removed from the configuration:

    xpack.osquery.enableExperimental:
${invalid.map(key => `      - ${key}`).join('\n')}
`);
  }
  return {
    ...pluginConfig,
    experimentalFeatures
  };
};
exports.createConfig = createConfig;