"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAllowedBuiltinTool = exports.isAllowedBuiltinAgent = exports.AGENT_BUILDER_BUILTIN_TOOLS = exports.AGENT_BUILDER_BUILTIN_AGENTS = void 0;
var _tools = require("@kbn/onechat-common/tools");
var _namespaces = require("@kbn/onechat-common/base/namespaces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is a manually maintained list of all built-in tools registered in Agent Builder.
 * The intention is to force a code review from the Agent Builder team when any team adds a new tool.
 */
const AGENT_BUILDER_BUILTIN_TOOLS = exports.AGENT_BUILDER_BUILTIN_TOOLS = [
// platform core tools are registered from the agent builder plugin so will trigger a review anyway
...Object.values(_tools.platformCoreTools),
// Observability
`${_namespaces.internalNamespaces.observability}.get_data_sources`, `${_namespaces.internalNamespaces.observability}.get_anomaly_detection_jobs`, `${_namespaces.internalNamespaces.observability}.run_log_rate_analysis`, `${_namespaces.internalNamespaces.observability}.get_log_categories`, `${_namespaces.internalNamespaces.observability}.get_alerts`, `${_namespaces.internalNamespaces.observability}.get_services`, `${_namespaces.internalNamespaces.observability}.get_downstream_dependencies`, `${_namespaces.internalNamespaces.observability}.get_correlated_logs`, `${_namespaces.internalNamespaces.observability}.get_hosts`,
// Dashboards
'platform.dashboard.create_dashboard', 'platform.dashboard.update_dashboard',
// Security Solution
`${_namespaces.internalNamespaces.security}.entity_risk_score`, `${_namespaces.internalNamespaces.security}.attack_discovery_search`, `${_namespaces.internalNamespaces.security}.security_labs_search`, `${_namespaces.internalNamespaces.security}.alerts`];

/**
 * This is a manually maintained list of all built-in agents registered in Agent Builder.
 * The intention is to force a code review from the Agent Builder team when any team adds a new agent.
 */
const AGENT_BUILDER_BUILTIN_AGENTS = exports.AGENT_BUILDER_BUILTIN_AGENTS = ['observability.agent', 'platform.dashboard.dashboard_agent', `${_namespaces.internalNamespaces.security}.agent`];
const isAllowedBuiltinTool = toolName => {
  return AGENT_BUILDER_BUILTIN_TOOLS.includes(toolName);
};
exports.isAllowedBuiltinTool = isAllowedBuiltinTool;
const isAllowedBuiltinAgent = agentName => {
  return AGENT_BUILDER_BUILTIN_AGENTS.includes(agentName);
};
exports.isAllowedBuiltinAgent = isAllowedBuiltinAgent;