"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRunAgentStepDefinition = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _server = require("@kbn/workflows-extensions/server");
var _run_agent_step = require("../../common/step_types/run_agent_step");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Server step definition for the onechat.runAgent step.
 * This step executes an onechat agent using the internal runner service.
 */
const getRunAgentStepDefinition = serviceManager => {
  return (0, _server.createServerStepDefinition)({
    ..._run_agent_step.runAgentStepCommonDefinition,
    handler: async context => {
      try {
        var _serviceManager$inter, _serviceManager$inter2, _result$round$respons;
        const {
          agent_id: agentId,
          message,
          schema
        } = context.input;
        context.logger.debug('onechat.runAgent step started');
        const request = context.contextManager.getFakeRequest();
        if (!request) {
          throw new Error('No request available in workflow context');
        }
        context.logger.debug('Executing onechat.runAgent step', {
          agentId: agentId || _onechatCommon.oneChatDefaultAgentId
        });
        const runner = await ((_serviceManager$inter = serviceManager.internalStart) === null || _serviceManager$inter === void 0 ? void 0 : (_serviceManager$inter2 = _serviceManager$inter.runnerFactory) === null || _serviceManager$inter2 === void 0 ? void 0 : _serviceManager$inter2.getRunner());
        if (!runner) {
          throw new Error('agent runner is not available');
        }
        const {
          result
        } = await runner.runAgent({
          agentId: agentId || _onechatCommon.oneChatDefaultAgentId,
          request,
          abortSignal: context.abortSignal,
          agentParams: {
            structuredOutput: !!schema,
            outputSchema: schema ? JSON.parse(schema) : undefined,
            nextInput: {
              message
            }
          }
        });
        context.logger.debug('onechat.runAgent step completed successfully');
        const outputMessage = schema ? result.round.response.structured_output : (_result$round$respons = result.round.response.message) !== null && _result$round$respons !== void 0 ? _result$round$respons : '';
        return {
          output: outputMessage
        };
      } catch (error) {
        context.logger.error('onechat.runAgent step failed', error instanceof Error ? error : new Error(String(error)));
        return {
          error: error instanceof Error ? error : new Error(String(error))
        };
      }
    }
  });
};
exports.getRunAgentStepDefinition = getRunAgentStepDefinition;