"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExecutableTool = exports.toDescriptorWithSchema = exports.toDescriptor = void 0;
var _zodToJsonSchema = _interopRequireDefault(require("zod-to-json-schema"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toExecutableTool = ({
  tool,
  runner,
  request,
  asInternal = false
}) => {
  const {
    getHandler,
    ...toolParts
  } = tool;
  return {
    ...toolParts,
    execute: params => {
      if (asInternal) {
        return runner.runInternalTool({
          ...params,
          tool,
          request
        });
      } else {
        return runner.runTool({
          ...params,
          toolId: tool.id,
          request
        });
      }
    }
  };
};

/**
 * Remove all additional properties from a tool descriptor.
 *
 * Can be used to convert/clean tool registration for public-facing APIs.
 */
exports.toExecutableTool = toExecutableTool;
const toDescriptorWithSchema = async tool => {
  const descriptor = toDescriptor(tool);
  const schema = await tool.getSchema();
  const jsonSchema = (0, _zodToJsonSchema.default)(schema);
  return {
    ...descriptor,
    schema: jsonSchema
  };
};
exports.toDescriptorWithSchema = toDescriptorWithSchema;
const toDescriptor = tool => {
  const {
    id,
    type,
    description,
    tags,
    configuration,
    readonly
  } = tool;
  return {
    id,
    type,
    description,
    tags,
    configuration,
    readonly
  };
};
exports.toDescriptor = toDescriptor;