"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateConfig = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _onechatGenaiUtils = require("@kbn/onechat-genai-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CCS_TOKEN = ':';
const validateConfig = async ({
  config,
  esClient
}) => {
  const {
    pattern
  } = config;
  if (pattern.includes(CCS_TOKEN)) {
    throw (0, _onechatCommon.createBadRequestError)(`Cross-cluster search is not supported by the index_search tool`);
  }
  const {
    indices,
    aliases,
    data_streams: dataStreams
  } = await (0, _onechatGenaiUtils.listSearchSources)({
    pattern: config.pattern,
    esClient
  });
  if (indices.length === 0 && aliases.length === 0 && dataStreams.length === 0) {
    throw (0, _onechatCommon.createBadRequestError)(`No sources found for pattern '${config.pattern}'`);
  }
};
exports.validateConfig = validateConfig;