"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolIndexName = exports.createStorage = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _onechatServer = require("@kbn/onechat-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toolIndexName = exports.toolIndexName = (0, _onechatServer.chatSystemIndex)('tools');
const storageSettings = {
  name: toolIndexName,
  schema: {
    properties: {
      id: _storageAdapter.types.keyword({}),
      type: _storageAdapter.types.keyword({}),
      space: _storageAdapter.types.keyword({}),
      description: _storageAdapter.types.text({}),
      configuration: _storageAdapter.types.object({
        dynamic: false,
        properties: {}
      }),
      tags: _storageAdapter.types.keyword({}),
      created_at: _storageAdapter.types.date({}),
      updated_at: _storageAdapter.types.date({})
    }
  }
};
const createStorage = ({
  logger,
  esClient
}) => {
  return new _storageAdapter.StorageIndexAdapter(esClient, logger, storageSettings);
};
exports.createStorage = createStorage;