"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunnerFactoryImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _model_provider = require("./model_provider");
var _runner = require("./runner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RunnerFactoryImpl {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "deps", void 0);
    this.deps = deps;
  }
  getRunner() {
    return (0, _runner.createRunner)(this.createRunnerDeps());
  }
  createRunnerDeps() {
    const {
      inference,
      trackingService,
      ...otherDeps
    } = this.deps;
    return {
      ...otherDeps,
      trackingService,
      modelProviderFactory: (0, _model_provider.createModelProviderFactory)({
        inference,
        trackingService
      })
    };
  }
}
exports.RunnerFactoryImpl = RunnerFactoryImpl;