"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationServiceImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../utils");
var _spaces = require("../../utils/spaces");
var _client = require("./client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConversationServiceImpl {
  constructor({
    logger,
    security,
    elasticsearch,
    spaces
  }) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "security", void 0);
    (0, _defineProperty2.default)(this, "elasticsearch", void 0);
    (0, _defineProperty2.default)(this, "spaces", void 0);
    this.logger = logger;
    this.security = security;
    this.elasticsearch = elasticsearch;
    this.spaces = spaces;
  }
  async getScopedClient({
    request
  }) {
    const user = (0, _utils.getUserFromRequest)(request, this.security);
    const esClient = this.elasticsearch.client.asScoped(request).asInternalUser;
    const space = (0, _spaces.getCurrentSpaceId)({
      request,
      spaces: this.spaces
    });
    return (0, _client.createClient)({
      user,
      esClient,
      logger: this.logger,
      space
    });
  }
}
exports.ConversationServiceImpl = ConversationServiceImpl;