"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRandomThinkingMessage = exports.getRandomAnsweringMessage = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const thinkingMessages = [_i18n.i18n.translate('xpack.onechat.agents.progress.thinking.message_1', {
  defaultMessage: 'Thinking about my next action'
}), _i18n.i18n.translate('xpack.onechat.agents.progress.thinking.message_2', {
  defaultMessage: 'Planning my next step'
}), _i18n.i18n.translate('xpack.onechat.agents.progress.thinking.message_3', {
  defaultMessage: 'Consulting my tools'
}), _i18n.i18n.translate('xpack.onechat.agents.progress.thinking.message_4', {
  defaultMessage: 'Analyzing the request'
}), _i18n.i18n.translate('xpack.onechat.agents.progress.thinking.message_5', {
  defaultMessage: 'Deciding what to do next'
})];
const answeringMessages = [_i18n.i18n.translate('xpack.onechat.agents.progress.answering.message_1', {
  defaultMessage: 'Summarizing my findings'
}), _i18n.i18n.translate('xpack.onechat.agents.progress.answering.message_2', {
  defaultMessage: 'Putting it all together'
}), _i18n.i18n.translate('xpack.onechat.agents.progress.answering.message_3', {
  defaultMessage: 'Synthesizing the results'
}), _i18n.i18n.translate('xpack.onechat.agents.progress.answering.message_4', {
  defaultMessage: 'Composing the final answer'
}), _i18n.i18n.translate('xpack.onechat.agents.progress.answering.message_5', {
  defaultMessage: 'Drafting the response'
})];
const getRandomMessage = messages => {
  return messages[Math.floor(Math.random() * messages.length)];
};
const getRandomThinkingMessage = () => getRandomMessage(thinkingMessages);
exports.getRandomThinkingMessage = getRandomThinkingMessage;
const getRandomAnsweringMessage = () => getRandomMessage(answeringMessages);
exports.getRandomAnsweringMessage = getRandomAnsweringMessage;