"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.labels = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const labels = exports.labels = {
  common: {
    optional: _i18n.i18n.translate('xpack.onechat.common.optional', {
      defaultMessage: 'Optional'
    })
  },
  conversations: {
    title: _i18n.i18n.translate('xpack.onechat.conversations.title', {
      defaultMessage: 'Agent Chat'
    })
  },
  tools: {
    // Landing page
    title: _i18n.i18n.translate('xpack.onechat.tools.title', {
      defaultMessage: 'Tools'
    }),
    newToolButton: _i18n.i18n.translate('xpack.onechat.tools.newToolButton', {
      defaultMessage: 'New tool'
    }),
    newToolTitle: _i18n.i18n.translate('xpack.onechat.tools.newToolTitle', {
      defaultMessage: 'Create a new tool'
    }),
    readOnly: _i18n.i18n.translate('xpack.onechat.tools.readOnly', {
      defaultMessage: 'Read-only'
    }),
    toolsTableCaption: toolsCount => _i18n.i18n.translate('xpack.onechat.tools.toolsTableCaption', {
      defaultMessage: 'Available tools for AI agents: {toolsCount} tools',
      values: {
        toolsCount
      }
    }),
    newIndexSearchToolTitle: _i18n.i18n.translate('xpack.onechat.tools.newIndexSearchTool.title', {
      defaultMessage: 'New index search tool'
    }),
    editIndexSearchToolTitle: _i18n.i18n.translate('xpack.onechat.tools.editIndexSearchTool.title', {
      defaultMessage: 'Edit index search tool'
    }),
    editToolContextMenuButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.editToolContextMenuButtonLabel', {
      defaultMessage: 'Edit tool context menu'
    }),
    saveButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.saveButtonLabel', {
      defaultMessage: 'Save'
    }),
    testButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.testButtonLabel', {
      defaultMessage: 'Test'
    }),
    saveAndTestButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.saveAndTestButtonLabel', {
      defaultMessage: 'Save & test'
    }),
    cancelButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    saveButtonTooltip: _i18n.i18n.translate('xpack.onechat.tools.saveButtonTooltip', {
      defaultMessage: 'Resolve all form errors to save.'
    }),
    // Table columns and labels
    toolIdLabel: _i18n.i18n.translate('xpack.onechat.tools.idLabel', {
      defaultMessage: 'ID'
    }),
    tagsLabel: _i18n.i18n.translate('xpack.onechat.tools.tagsLabel', {
      defaultMessage: 'Labels'
    }),
    toolsLabel: _i18n.i18n.translate('xpack.onechat.tools.toolsLabel', {
      defaultMessage: 'Tools'
    }),
    // Tool types
    esqlLabel: _i18n.i18n.translate('xpack.onechat.tools.esqlLabel', {
      defaultMessage: 'ES|QL'
    }),
    builtinLabel: _i18n.i18n.translate('xpack.onechat.tools.builtinLabel', {
      defaultMessage: 'System'
    }),
    mcpLabel: _i18n.i18n.translate('xpack.onechat.tools.mcpLabel', {
      defaultMessage: 'MCP'
    }),
    searchLabel: _i18n.i18n.translate('xpack.onechat.tools.searchLabel', {
      defaultMessage: 'Search'
    }),
    indexTypeLabel: _i18n.i18n.translate('xpack.onechat.tools.indexTypeLabel', {
      defaultMessage: 'Index'
    }),
    aliasTypeLabel: _i18n.i18n.translate('xpack.onechat.tools.aliasTypeLabel', {
      defaultMessage: 'Alias'
    }),
    dataStreamTypeLabel: _i18n.i18n.translate('xpack.onechat.tools.dataStreamTypeLabel', {
      defaultMessage: 'Data stream'
    }),
    // MCP tool health status
    mcpHealthStatus: {
      toolNotFound: {
        title: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthStatus.toolNotFound.title', {
          defaultMessage: 'Tool not found on MCP server'
        }),
        description: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthStatus.toolNotFound.description', {
          defaultMessage: 'It may have been removed or renamed.'
        })
      },
      connectorNotFound: {
        title: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthStatus.connectorNotFound.title', {
          defaultMessage: 'MCP connector unavailable'
        }),
        description: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthStatus.connectorNotFound.description', {
          defaultMessage: 'Check your MCP server connection'
        })
      },
      listToolsFailed: {
        title: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthStatus.listToolsFailed.title', {
          defaultMessage: "Can't retrieve tools from MCP server"
        }),
        description: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthStatus.listToolsFailed.description', {
          defaultMessage: 'Check your MCP server connection'
        })
      },
      toolUnhealthy: {
        title: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthStatus.toolUnhealthy.title', {
          defaultMessage: 'Tool execution failed'
        }),
        description: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthStatus.toolUnhealthy.description', {
          defaultMessage: 'Check your MCP server connection'
        })
      }
    },
    // Actions
    editToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.editToolButtonLabel', {
      defaultMessage: 'Edit'
    }),
    viewToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.viewToolButtonLabel', {
      defaultMessage: 'View'
    }),
    deleteToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.deleteToolButtonLabel', {
      defaultMessage: 'Delete'
    }),
    testToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.testToolButtonLabel', {
      defaultMessage: 'Test'
    }),
    cloneToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.cloneToolButtonLabel', {
      defaultMessage: 'Clone'
    }),
    toolContextMenuButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.toolContextMenuButtonLabel', {
      defaultMessage: 'Tool context menu'
    }),
    // Table header and bulk actions
    deleteSelectedToolsButtonLabel: count => _i18n.i18n.translate('xpack.onechat.tools.deleteSelectedToolsButtonLabel', {
      defaultMessage: 'Delete {count, plural, one {# Tool} other {# Tools}}',
      values: {
        count
      }
    }),
    selectAllToolsButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.selectAllToolsButtonLabel', {
      defaultMessage: 'Select all'
    }),
    clearSelectionButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.clearSelectionButtonLabel', {
      defaultMessage: 'Clear selection'
    }),
    includeSystemToolsSwitchLabel: _i18n.i18n.translate('xpack.onechat.tools.includeSystemToolsSwitchLabel', {
      defaultMessage: 'Include system tools'
    }),
    // Search and filters
    searchToolsPlaceholder: _i18n.i18n.translate('xpack.onechat.tools.searchToolsPlaceholder', {
      defaultMessage: 'Search'
    }),
    typeFilter: _i18n.i18n.translate('xpack.onechat.tools.typeFilter', {
      defaultMessage: 'Type'
    }),
    tagsFilter: _i18n.i18n.translate('xpack.onechat.tools.tagsFilter', {
      defaultMessage: 'Labels'
    }),
    // Empty states and messages
    noEsqlToolsMatchMessage: _i18n.i18n.translate('xpack.onechat.tools.noEsqlToolsMatchMessage', {
      defaultMessage: 'No tools match your search.'
    }),
    noEsqlToolsMessage: _i18n.i18n.translate('xpack.onechat.tools.noEsqlToolsMessage', {
      defaultMessage: "It looks like you don't have any ES|QL tools defined yet."
    }),
    listToolsErrorMessage: _i18n.i18n.translate('xpack.onechat.tools.listToolsErrorMessage', {
      defaultMessage: 'Failed to fetch tools'
    }),
    // Success toasts
    deleteToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.deleteToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" deleted',
      values: {
        toolId
      }
    }),
    bulkDeleteToolsSuccessToast: count => _i18n.i18n.translate('xpack.onechat.tools.bulkDeleteToolsSuccessToast', {
      defaultMessage: 'Deleted {count, plural, one {# tool} other {# tools}}',
      values: {
        count
      }
    }),
    createEsqlToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.createEsqlToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" created',
      values: {
        toolId
      }
    }),
    editEsqlToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.editEsqlToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" updated',
      values: {
        toolId
      }
    }),
    createIndexSearchToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.createIndexSearchToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" created',
      values: {
        toolId
      }
    }),
    editIndexSearchToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.editIndexSearchToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" updated',
      values: {
        toolId
      }
    }),
    // Error toasts
    deleteToolErrorToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.deleteToolErrorToast', {
      defaultMessage: 'Unable to delete tool "{toolId}"',
      values: {
        toolId
      }
    }),
    bulkDeleteToolsErrorToast: count => _i18n.i18n.translate('xpack.onechat.tools.bulkDeleteToolsErrorToast', {
      defaultMessage: 'Unable to delete {count, plural, one {# tool} other {# tools}}',
      values: {
        count
      }
    }),
    createEsqlToolErrorToast: _i18n.i18n.translate('xpack.onechat.tools.createEsqlToolErrorToast', {
      defaultMessage: 'Unable to create tool'
    }),
    editEsqlToolErrorToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.editEsqlToolErrorToast', {
      defaultMessage: 'Unable to update tool "{toolId}"',
      values: {
        toolId
      }
    }),
    searchToolsErrorToast: _i18n.i18n.translate('xpack.onechat.tools.searchToolsErrorToast', {
      defaultMessage: 'Error searching tools'
    }),
    loadToolErrorToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.loadToolErrorToast', {
      defaultMessage: 'Unable to load "{toolId}"',
      values: {
        toolId
      }
    }),
    loadToolsErrorToast: _i18n.i18n.translate('xpack.onechat.tools.loadToolsErrorToast', {
      defaultMessage: 'Unable to load tools'
    }),
    // Delete modals
    deleteEsqlToolTitle: toolId => _i18n.i18n.translate('xpack.onechat.tools.deleteEsqlToolTitle', {
      defaultMessage: 'Delete {toolId}?',
      values: {
        toolId
      }
    }),
    deleteEsqlToolCancelButton: _i18n.i18n.translate('xpack.onechat.tools.deleteEsqlToolCancelButton', {
      defaultMessage: 'Cancel'
    }),
    deleteEsqlToolConfirmButton: _i18n.i18n.translate('xpack.onechat.tools.deleteEsqlToolConfirmButton', {
      defaultMessage: 'Delete tool'
    }),
    deleteEsqlToolConfirmationText: _i18n.i18n.translate('xpack.onechat.tools.deleteEsqlToolConfirmationText', {
      defaultMessage: 'This action will permanently remove the tool. This cannot be undone.'
    }),
    // Bulk delete modal
    bulkDeleteEsqlToolsTitle: count => _i18n.i18n.translate('xpack.onechat.tools.bulkDeleteEsqlToolsTitle', {
      defaultMessage: 'Delete {count, plural, one {# tool} other {# tools}}?',
      values: {
        count
      }
    }),
    bulkDeleteEsqlToolsConfirmationText: _i18n.i18n.translate('xpack.onechat.tools.bulkDeleteEsqlToolsConfirmationText', {
      defaultMessage: "You can't recover deleted data."
    }),
    testTool: {
      backToEditToolButton: _i18n.i18n.translate('xpack.onechat.tools.testTool.backToEditToolButton', {
        defaultMessage: 'Back to edit tool'
      })
    },
    // Bulk import MCP tools
    bulkImportMcp: {
      title: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.title', {
        defaultMessage: 'Bulk import MCP tools'
      }),
      description: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.description', {
        defaultMessage: 'Select an MCP server and import multiple tools at once to make them available in Agent Builder.'
      }),
      importToolsButton: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.importToolsButton', {
        defaultMessage: 'Import tools'
      }),
      cancelButton: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.cancelButton', {
        defaultMessage: 'Cancel'
      }),
      sourceSection: {
        title: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.title', {
          defaultMessage: 'Source'
        }),
        description: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.description', {
          defaultMessage: 'Select the MCP server and preview the tools available for import.'
        }),
        mcpServerLabel: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.mcpServerLabel', {
          defaultMessage: 'MCP Server'
        }),
        addMcpServerLink: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.addMcpServerLink', {
          defaultMessage: 'Add a new MCP server'
        }),
        toolsToImportLabel: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.toolsToImportLabel', {
          defaultMessage: 'Tools to import'
        }),
        nameColumn: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.nameColumn', {
          defaultMessage: 'Name'
        }),
        searchPlaceholder: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.searchPlaceholder', {
          defaultMessage: 'Search tools'
        }),
        selectedCount: selected => _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.selectedCount', {
          defaultMessage: '{selected} Selected',
          values: {
            selected
          }
        }),
        clearSelection: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.clearSelection', {
          defaultMessage: 'Clear selection'
        }),
        selectMcpServerMessage: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.selectMcpServerMessage', {
          defaultMessage: 'Select an MCP server to see available tools.'
        }),
        noToolsMessage: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.noToolsMessage', {
          defaultMessage: 'No tools found on the selected MCP server.'
        }),
        noMatchingToolsMessage: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.noMatchingToolsMessage', {
          defaultMessage: 'No tools match your search.'
        }),
        loadingToolsMessage: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.loadingToolsMessage', {
          defaultMessage: 'Loading tools...'
        }),
        toolsErrorMessage: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.toolsErrorMessage', {
          defaultMessage: 'Failed to load tools from the selected MCP server.'
        }),
        tableCaption: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.sourceSection.tableCaption', {
          defaultMessage: 'MCP tools available for import'
        })
      },
      organizationSection: {
        title: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.organizationSection.title', {
          defaultMessage: 'Organization'
        }),
        description: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.organizationSection.description', {
          defaultMessage: 'Choose how imported tools should be grouped and labeled.'
        }),
        namespaceLabel: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.organizationSection.namespaceLabel', {
          defaultMessage: 'Namespace'
        }),
        namespaceHelpText: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.organizationSection.namespaceHelpText', {
          defaultMessage: 'Minimum 1 character'
        }),
        labelsLabel: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.organizationSection.labelsLabel', {
          defaultMessage: 'Labels'
        })
      },
      importSuccessToast: count => _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.importSuccessToast', {
        defaultMessage: 'Successfully imported {count, plural, one {# tool} other {# tools}}',
        values: {
          count
        }
      }),
      importErrorToast: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.importErrorToast', {
        defaultMessage: 'Failed to import MCP tools'
      }),
      noToolsSelectedError: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.noToolsSelectedError', {
        defaultMessage: 'Please select at least one tool to import.'
      })
    }
  },
  agents: {
    title: _i18n.i18n.translate('xpack.onechat.agents.list.title', {
      defaultMessage: 'Agents'
    }),
    newAgent: _i18n.i18n.translate('xpack.onechat.agents.new.title', {
      defaultMessage: 'New Agent'
    }),
    editAgent: _i18n.i18n.translate('xpack.onechat.agents.edit.title', {
      defaultMessage: 'Edit Agent'
    }),
    createAgent: _i18n.i18n.translate('xpack.onechat.agents.create.title', {
      defaultMessage: 'Create Agent'
    }),
    settings: {
      cancelButtonLabel: _i18n.i18n.translate('xpack.onechat.agents.form.settings.cancelButtonLabel', {
        defaultMessage: 'Cancel'
      })
    }
  },
  navigationAbort: {
    title: _i18n.i18n.translate('xpack.onechat.navigationAbort.title', {
      defaultMessage: 'Abort chat request?'
    }),
    message: _i18n.i18n.translate('xpack.onechat.navigationAbort.message', {
      defaultMessage: 'A chat request is in progress. Do you want to navigate away and abort it?'
    }),
    confirmButton: _i18n.i18n.translate('xpack.onechat.navigationAbort.confirmButton', {
      defaultMessage: 'Yes, abort'
    })
  }
};