"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolTypes = void 0;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _onechatCommon = require("@kbn/onechat-common");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _query_keys = require("../../query_keys");
var _use_onechat_service = require("../use_onechat_service");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useToolTypes = () => {
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    services: {
      settings
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data: serverToolTypes = [],
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.typeInfo,
    queryFn: () => toolsService.getToolTypes()
  });
  const workflowsEnabled = (0, _react.useMemo)(() => settings.client.get('workflows:ui:enabled', false), [settings]);
  const mcpEnabled = (0, _react.useMemo)(() => settings.client.get(_managementSettingsIds.AGENT_BUILDER_EXTERNAL_MCP_SETTING_ID, false), [settings]);
  const toolTypes = (0, _react.useMemo)(() => {
    return serverToolTypes.filter(toolType => (mcpEnabled || toolType.type !== _onechatCommon.ToolType.mcp) && (workflowsEnabled || toolType.type !== _onechatCommon.ToolType.workflow));
  }, [serverToolTypes, workflowsEnabled, mcpEnabled]);
  return {
    toolTypes,
    isLoading
  };
};
exports.useToolTypes = useToolTypes;