"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolForm = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _reactHookForm = require("react-hook-form");
var _tools_form_registry = require("../../components/tools/form/registry/tools_form_registry");
var _use_tool_registry_resolver = require("./use_tool_registry_resolver");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useToolForm = (tool, selectedToolType) => {
  var _ref, _tool$type;
  const toolType = (_ref = (_tool$type = tool === null || tool === void 0 ? void 0 : tool.type) !== null && _tool$type !== void 0 ? _tool$type : selectedToolType) !== null && _ref !== void 0 ? _ref : _onechatCommon.ToolType.esql;
  const dynamicResolver = (0, _use_tool_registry_resolver.useToolRegistryResolver)();
  const form = (0, _reactHookForm.useForm)({
    defaultValues: (0, _tools_form_registry.getToolTypeDefaultValues)(toolType),
    resolver: dynamicResolver,
    mode: 'onBlur'
  });
  return form;
};
exports.useToolForm = useToolForm;