"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkImportMcpToolFormValidationSchema = exports.bulkImportMcpI18nMessages = void 0;
var _i18n = require("@kbn/i18n");
var _namespaces = require("@kbn/onechat-common/base/namespaces");
var _tools = require("@kbn/onechat-common/tools");
var _reactQuery = require("@kbn/react-query");
var _zod = require("@kbn/zod");
var _use_onechat_service = require("../../../../hooks/use_onechat_service");
var _query_keys = require("../../../../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkImportMcpI18nMessages = exports.bulkImportMcpI18nMessages = {
  connectorId: {
    requiredError: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.validation.connectorId.requiredError', {
      defaultMessage: 'MCP server is required.'
    })
  },
  tools: {
    requiredError: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.validation.tools.requiredError', {
      defaultMessage: 'At least one tool is required.'
    })
  },
  namespace: {
    requiredError: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.validation.namespace.requiredError', {
      defaultMessage: 'Namespace is required.'
    }),
    tooLongError: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.validation.namespace.tooLongError', {
      defaultMessage: 'Namespace must be {maxLength} characters or less.',
      values: {
        maxLength: _tools.toolIdMaxLength
      }
    }),
    formatError: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.validation.namespace.formatError', {
      defaultMessage: 'Namespace must start with a letter and contain only lowercase letters, numbers, and hyphens.'
    }),
    protectedNamespaceError: name => _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.validation.namespace.protectedNamespaceError', {
      defaultMessage: '"{name}" is a protected namespace and cannot be used.',
      values: {
        name
      }
    }),
    conflictError: _i18n.i18n.translate('xpack.onechat.tools.bulkImportMcp.validation.namespace.conflictError', {
      defaultMessage: 'This namespace is already in use by existing tools.'
    })
  }
};
const useBulkImportMcpToolFormValidationSchema = () => {
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  return _zod.z.object({
    connectorId: _zod.z.string().min(1, {
      message: bulkImportMcpI18nMessages.connectorId.requiredError
    }),
    tools: _zod.z.array(_zod.z.object({
      name: _zod.z.string(),
      description: _zod.z.string()
    })).min(1, {
      message: bulkImportMcpI18nMessages.tools.requiredError
    }),
    namespace: _zod.z.string().min(1, {
      message: bulkImportMcpI18nMessages.namespace.requiredError
    }).max(_tools.toolIdMaxLength, {
      message: bulkImportMcpI18nMessages.namespace.tooLongError
    }).regex(_tools.toolIdRegexp, {
      message: bulkImportMcpI18nMessages.namespace.formatError
    }).refine(name => !(0, _namespaces.isInProtectedNamespace)(name) && !(0, _namespaces.hasNamespaceName)(name), name => ({
      message: bulkImportMcpI18nMessages.namespace.protectedNamespaceError(name)
    })).superRefine(async (value, ctx) => {
      if (value.length > 0) {
        const {
          isValid
        } = await queryClient.fetchQuery({
          queryKey: _query_keys.queryKeys.tools.namespace.validate(value),
          queryFn: () => toolsService.validateNamespace({
            namespace: value
          }),
          staleTime: 0
        });
        if (!isValid) {
          ctx.addIssue({
            code: _zod.z.ZodIssueCode.custom,
            message: bulkImportMcpI18nMessages.namespace.conflictError
          });
        }
      }
    }),
    labels: _zod.z.array(_zod.z.string())
  });
};
exports.useBulkImportMcpToolFormValidationSchema = useBulkImportMcpToolFormValidationSchema;