"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolFormMode = exports.ToolForm = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _type = require("./sections/type");
var _labels = require("./sections/labels");
var _details = require("./sections/details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/tool_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ToolFormMode = exports.ToolFormMode = /*#__PURE__*/function (ToolFormMode) {
  ToolFormMode["Create"] = "create";
  ToolFormMode["Edit"] = "edit";
  ToolFormMode["View"] = "view";
  return ToolFormMode;
}({});
const ToolForm = ({
  mode,
  formId,
  saveTool
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    handleSubmit
  } = (0, _reactHookForm.useFormContext)();
  const isViewMode = mode === ToolFormMode.View;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, {
    component: "form",
    id: formId,
    onSubmit: !isViewMode ? handleSubmit(saveTool) : undefined,
    fullWidth: true,
    css: (0, _react.css)`
        .euiFormHelpText {
          color: ${euiTheme.colors.textSubdued};
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, !isViewMode && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_type.TypeSection, {
    mode: mode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_details.DetailsSection, {
    mode: mode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_labels.LabelsSection, {
    mode: mode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
exports.ToolForm = ToolForm;