"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mcpToolRegistryEntry = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _tools = require("@kbn/onechat-common/tools");
var _transform_mcp_form_data = require("../../../../../utils/transform_mcp_form_data");
var _zod_resolver = require("../../../../../utils/zod_resolver");
var _i18n = require("../../i18n");
var _mcp_configuration_fields = require("../../sections/configuration_fields/mcp_configuration_fields");
var _mcp_tool_form_validation = require("../../validation/mcp_tool_form_validation");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mcpToolRegistryEntry = exports.mcpToolRegistryEntry = {
  label: _i18n.i18nMessages.configuration.form.type.mcpOption,
  getConfigurationComponent: () => _mcp_configuration_fields.McpConfiguration,
  defaultValues: {
    ..._common.commonToolFormDefaultValues,
    type: _onechatCommon.ToolType.mcp,
    connectorId: '',
    mcpToolName: ''
  },
  toolToFormData: tool => {
    if (!(0, _tools.isMcpTool)(tool)) {
      throw new Error('Expected MCP tool');
    }
    return (0, _transform_mcp_form_data.transformMcpToolToFormData)(tool);
  },
  formDataToCreatePayload: _transform_mcp_form_data.transformMcpFormDataForCreate,
  formDataToUpdatePayload: _transform_mcp_form_data.transformMcpFormDataForUpdate,
  getValidationResolver: () => (0, _zod_resolver.zodResolver)(_mcp_tool_form_validation.mcpToolFormValidationSchema)
};