"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlToolFormRegistryEntry = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _tools = require("@kbn/onechat-common/tools");
var _esql_configuration_fields = require("../../sections/configuration_fields/esql_configuration_fields");
var _transform_esql_form_data = require("../../../../../utils/transform_esql_form_data");
var _esql_tool_form_validation = require("../../validation/esql_tool_form_validation");
var _zod_resolver = require("../../../../../utils/zod_resolver");
var _i18n = require("../../i18n");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const esqlToolFormRegistryEntry = exports.esqlToolFormRegistryEntry = {
  label: _i18n.i18nMessages.configuration.form.type.esqlOption,
  getConfigurationComponent: () => _esql_configuration_fields.EsqlConfiguration,
  defaultValues: {
    ..._common.commonToolFormDefaultValues,
    esql: '',
    params: [],
    type: _onechatCommon.ToolType.esql
  },
  toolToFormData: tool => {
    if (!(0, _tools.isEsqlTool)(tool)) {
      throw new Error('Expected ESQL tool');
    }
    return (0, _transform_esql_form_data.transformEsqlToolToFormData)(tool);
  },
  formDataToCreatePayload: _transform_esql_form_data.transformEsqlFormDataForCreate,
  formDataToUpdatePayload: _transform_esql_form_data.transformEsqlFormDataForUpdate,
  getValidationResolver: () => (0, _zod_resolver.zodResolver)(_esql_tool_form_validation.esqlFormValidationSchema)
};