"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.McpReadOnlyFields = void 0;
var _eui = require("@elastic/eui");
var _onechatCommon = require("@kbn/onechat-common");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _app_paths = require("../../../../../utils/app_paths");
var _i18n = require("../../../../../utils/i18n");
var _mcp = require("../../types/mcp");
var _use_tools_health = require("../../../../../hooks/tools/use_tools_health");
var _tools_provider = require("../../../../../context/tools_provider");
var _use_mcp_connectors = require("../../../../../hooks/tools/use_mcp_connectors");
var _use_navigation = require("../../../../../hooks/use_navigation");
var _mcp_health_banner = require("./mcp_health_banner");
var _use_edit_mcp_server_flyout = require("../../hooks/use_edit_mcp_server_flyout");
var _i18n2 = require("../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/components/mcp/mcp_readonly_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const McpReadOnlyFields = ({
  mcpHealthStatus,
  setMcpHealthStatus
}) => {
  const {
    createTool,
    deleteTool
  } = (0, _tools_provider.useToolsActions)();
  const {
    navigateToManageConnectors,
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    control,
    setError,
    clearErrors
  } = (0, _reactHookForm.useFormContext)();
  const [connectorId, mcpToolName, toolId] = (0, _reactHookForm.useWatch)({
    control,
    name: ['connectorId', 'mcpToolName', 'toolId']
  });
  const {
    toolHealth,
    isLoading: isLoadingToolHealth
  } = (0, _use_tools_health.useToolHealth)({
    toolId
  });
  const {
    connector,
    isLoading: isLoadingConnector,
    failureReason: loadingConnectorError
  } = (0, _use_mcp_connectors.useGetConnector)({
    connectorId
  });
  const {
    openFlyout: openEditMcpServerFlyout,
    isOpen: isEditMcpServerFlyoutOpen,
    flyout: editMcpServerFlyout
  } = (0, _use_edit_mcp_server_flyout.useEditMcpServerFlyout)({
    connector
  });
  const {
    mcpTools,
    isLoading: isLoadingMcpTools,
    failureReason: loadingMcpToolsError
  } = (0, _use_mcp_connectors.useListMcpTools)({
    connectorId
  });
  (0, _react.useEffect)(() => {
    if (isLoadingConnector || isLoadingMcpTools || isLoadingToolHealth) {
      return;
    }

    // MCP connector deleted
    if (loadingConnectorError) {
      setMcpHealthStatus(_mcp.McpToolHealthStatus.ConnectorNotFound);
      setError('connectorId', {
        message: _i18n.labels.tools.mcpHealthStatus.connectorNotFound.title
      });
      return;
    }

    // MCP tools not found
    if (loadingMcpToolsError) {
      setMcpHealthStatus(_mcp.McpToolHealthStatus.ListToolsFailed);
      setError('connectorId', {
        message: _i18n.labels.tools.mcpHealthStatus.listToolsFailed.title
      });
      return;
    }

    // MCP tool not found
    if (!mcpTools.find(tool => tool.name === mcpToolName)) {
      setMcpHealthStatus(_mcp.McpToolHealthStatus.ToolNotFound);
      setError('mcpToolName', {
        message: _i18n.labels.tools.mcpHealthStatus.toolNotFound.title
      });
      return;
    }

    // MCP tool is unhealthy; treat no health data as healthy
    if (toolHealth && toolHealth.status !== 'healthy') {
      setMcpHealthStatus(_mcp.McpToolHealthStatus.ToolUnhealthy);
      setError('mcpToolName', {
        message: _i18n.labels.tools.mcpHealthStatus.toolUnhealthy.title
      });
      return;
    }
    setMcpHealthStatus(_mcp.McpToolHealthStatus.Healthy);
    clearErrors(['connectorId', 'mcpToolName']);
  }, [mcpToolName, mcpTools, toolHealth, loadingConnectorError, loadingMcpToolsError, isLoadingConnector, isLoadingMcpTools, isLoadingToolHealth, setMcpHealthStatus, setError, clearErrors]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, mcpHealthStatus && /*#__PURE__*/_react.default.createElement(_mcp_health_banner.McpHealthBanner, {
    status: mcpHealthStatus,
    onDeleteTool: () => deleteTool(toolId, {
      onConfirm: () => navigateToOnechatUrl(_app_paths.appPaths.tools.list)
    }),
    onCreateNewTool: () => createTool(_onechatCommon.ToolType.mcp),
    onViewConnectors: navigateToManageConnectors,
    onViewMcpServer: openEditMcpServerFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n2.i18nMessages.configuration.form.mcp.connectorLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: connector ? [{
      label: connector.name
    }] : [],
    isLoading: isLoadingConnector,
    isDisabled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n2.i18nMessages.configuration.form.mcp.mcpToolLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: connector && mcpToolName ? [{
      label: mcpToolName
    }] : [],
    isLoading: isLoadingConnector,
    isDisabled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  })), isEditMcpServerFlyoutOpen && editMcpServerFlyout);
};
exports.McpReadOnlyFields = McpReadOnlyFields;