"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrganizationSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _use_tool_tags = require("../../../../hooks/tools/use_tool_tags");
var _i18n = require("../../../../utils/i18n");
var _tool_form_section = require("../../form/components/tool_form_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/bulk_import/sections/organization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OrganizationSection = () => {
  var _errors$namespace;
  const {
    control,
    formState
  } = (0, _reactHookForm.useFormContext)();
  const {
    errors
  } = formState;
  const {
    tags,
    isLoading: isLoadingTags
  } = (0, _use_tool_tags.useToolsTags)();
  const labelsOptions = (0, _react.useMemo)(() => tags.map(tag => ({
    label: tag
  })), [tags]);
  return /*#__PURE__*/_react.default.createElement(_tool_form_section.ToolFormSection, {
    title: _i18n.labels.tools.bulkImportMcp.organizationSection.title,
    icon: "tag",
    description: _i18n.labels.tools.bulkImportMcp.organizationSection.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.labels.tools.bulkImportMcp.organizationSection.namespaceLabel,
    helpText: _i18n.labels.tools.bulkImportMcp.organizationSection.namespaceHelpText,
    isInvalid: !!errors.namespace,
    error: (_errors$namespace = errors.namespace) === null || _errors$namespace === void 0 ? void 0 : _errors$namespace.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "namespace",
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      isInvalid: !!errors.namespace,
      fullWidth: true,
      "data-test-subj": "bulkImportMcpToolsNamespaceInput"
    }, field, {
      inputRef: ref,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.labels.tools.bulkImportMcp.organizationSection.labelsLabel,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }, _i18n.labels.common.optional),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "labels",
    render: ({
      field: {
        value,
        onChange,
        ref,
        ...field
      },
      fieldState: {
        invalid
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
      options: labelsOptions,
      selectedOptions: value.map(label => ({
        label
      })),
      onChange: selectedOptions => {
        onChange(selectedOptions.map(option => option.label));
      },
      onCreateOption: newTag => {
        onChange([...value, newTag]);
      },
      isClearable: true,
      isLoading: isLoadingTags,
      isInvalid: invalid,
      fullWidth: true,
      inputRef: ref,
      "data-test-subj": "bulkImportMcpToolsLabelsSelect"
    }, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })));
};
exports.OrganizationSection = OrganizationSection;