"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScrollButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/scroll_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ScrollButton = ({
  onClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const scrollDownButtonStyles = (0, _react2.css)`
    position: absolute;
    bottom: ${euiTheme.size.s};
    left: 50%;
    transform: translateX(-50%);
    z-index: 1;
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    size: "s",
    color: "text",
    css: scrollDownButtonStyles,
    iconType: "sortDown",
    "aria-label": "Scroll down",
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  });
};
exports.ScrollButton = ScrollButton;