"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundSteps = void 0;
var _conversation = require("@kbn/onechat-common/chat/conversation");
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _tool_response_flyout = require("./tool_response_flyout");
var _use_tool_results_flyout = require("../../../../../hooks/thinking/use_tool_results_flyout");
var _thinking_item_layout = require("./thinking_item_layout");
var _tool_call_display = require("./tool_call_display");
var _tool_progress_display = require("./tool_progress_display");
var _tool_result_display = require("./tool_result_display");
var _flyout_result_item = require("./flyout_result_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/steps/round_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  roundThinkingSteps: _i18n.i18n.translate('xpack.onechat.conversation.thinking.stepsList', {
    defaultMessage: 'Round thinking steps'
  }),
  agentReasoning: _i18n.i18n.translate('xpack.onechat.thinking.agentReasoningLabel', {
    defaultMessage: 'Agent reasoning'
  }),
  flyoutTitle: _i18n.i18n.translate('xpack.onechat.thinking.flyoutTitle', {
    defaultMessage: 'Tool response details'
  }),
  loading: _i18n.i18n.translate('xpack.onechat.conversation.thinking.loading', {
    defaultMessage: 'Loading...'
  })
};

// Exposed in main thinking chain, for now query and tabular data
const mainThinkingResultTypes = [_tool_result.ToolResultType.query, _tool_result.ToolResultType.tabularData, _tool_result.ToolResultType.error];
// Populated in flyout
const flyoutResultTypes = [_tool_result.ToolResultType.visualization, _tool_result.ToolResultType.other, _tool_result.ToolResultType.resource];
// Tool result types that should not have an icon displayed in the thinking steps list
const disabledToolResultIconTypes = [_tool_result.ToolResultType.error, _tool_result.ToolResultType.query];
const getItemIcon = (isLastItem, isLoading) => {
  if (isLastItem && isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "doubleArrowRight",
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 10
    }
  });
};
const RoundSteps = ({
  steps,
  isLoading
}) => {
  // Each step will map to multiple thinking items
  // In the case of tool call steps we'll have
  // an item for the tool call, items for the progression, and items for the tool call results

  const {
    toolResults,
    isOpen: isToolResultsFlyoutOpen,
    openFlyout,
    closeFlyout
  } = (0, _use_tool_results_flyout.useToolResultsFlyout)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const renderedSteps = (0, _react.useMemo)(() => {
    const itemFactories = [];

    // First pass: build all item factories to determine total count
    steps.forEach((step, stepIndex) => {
      if ((0, _conversation.isToolCallStep)(step)) {
        var _step$progression;
        itemFactories.push({
          key: `step-${stepIndex}-tool-call`,
          factory: (icon, textColor) => /*#__PURE__*/_react.default.createElement(_tool_call_display.ToolCallDisplay, {
            key: `step-${stepIndex}-tool-call`,
            step: step,
            icon: icon,
            textColor: textColor,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 90,
              columnNumber: 13
            }
          })
        });

        // Add progression items
        (_step$progression = step.progression) === null || _step$progression === void 0 ? void 0 : _step$progression.forEach((progress, progressIndex) => {
          itemFactories.push({
            key: `step-${stepIndex}-${step.tool_id}-progress-${progressIndex}`,
            factory: (icon, textColor) => /*#__PURE__*/_react.default.createElement(_tool_progress_display.ToolProgressDisplay, {
              key: `step-${stepIndex}-${step.tool_id}-progress-${progressIndex}`,
              progress: progress,
              icon: icon,
              textColor: textColor,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 104,
                columnNumber: 15
              }
            })
          });
        });

        // Add main thinking result items
        step.results.filter(result => mainThinkingResultTypes.includes(result.type)).forEach((result, resultIndex) => {
          itemFactories.push({
            key: `step-${stepIndex}-${step.tool_id}-result-${resultIndex}`,
            factory: (icon, textColor) => {
              const shouldDisableIcon = disabledToolResultIconTypes.includes(result.type);
              return /*#__PURE__*/_react.default.createElement(_thinking_item_layout.ThinkingItemLayout, {
                key: `step-${stepIndex}-${step.tool_id}-result-${resultIndex}`,
                icon: shouldDisableIcon ? undefined : icon,
                textColor: textColor,
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 123,
                  columnNumber: 19
                }
              }, /*#__PURE__*/_react.default.createElement(_tool_result_display.ToolResultDisplay, {
                toolResult: result,
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 128,
                  columnNumber: 21
                }
              }));
            }
          });
        });

        // Add flyout result items
        const flyoutResultItems = step.results.filter(result => flyoutResultTypes.includes(result.type));
        if (flyoutResultItems.length > 0) {
          itemFactories.push({
            key: `step-${stepIndex}-${step.tool_id}-result-flyout`,
            factory: (icon, textColor) => /*#__PURE__*/_react.default.createElement(_flyout_result_item.FlyoutResultItem, {
              key: `step-${stepIndex}-${step.tool_id}-result-flyout`,
              step: step,
              stepIndex: stepIndex,
              flyoutResultItems: flyoutResultItems,
              onOpenFlyout: openFlyout,
              icon: icon,
              textColor: textColor,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 143,
                columnNumber: 15
              }
            })
          });
        }
      } else if ((0, _conversation.isReasoningStep)(step) && !step.transient) {
        itemFactories.push({
          key: `step-reasoning-${stepIndex}`,
          factory: (icon, textColor) => /*#__PURE__*/_react.default.createElement(_thinking_item_layout.ThinkingItemLayout, {
            key: `step-reasoning-${stepIndex}`,
            icon: icon,
            textColor: textColor,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 159,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("div", {
            role: "status",
            "aria-live": "polite",
            "aria-label": labels.agentReasoning,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 164,
              columnNumber: 15
            }
          }, step.reasoning))
        });
      }
    });
    const totalItems = itemFactories.length;

    // Second pass: map over factories and create items with icons based on flat position
    // The last item should always be loading unless the round has completed
    return itemFactories.map((itemFactory, flatIndex) => {
      const isLastItem = flatIndex === totalItems - 1;
      const itemIcon = getItemIcon(isLastItem, isLoading);
      const getItemTextColor = () => {
        if (isLastItem && isLoading) {
          return euiTheme.colors.textParagraph;
        }
        return euiTheme.colors.textSubdued;
      };
      const textColor = getItemTextColor();
      return itemFactory.factory(itemIcon, textColor);
    });
  }, [steps, openFlyout, isLoading, euiTheme.colors.textSubdued, euiTheme.colors.textParagraph]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    "aria-label": labels.roundThinkingSteps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, renderedSteps), /*#__PURE__*/_react.default.createElement(_tool_response_flyout.ToolResponseFlyout, {
    isOpen: isToolResultsFlyoutOpen,
    onClose: closeFlyout,
    "aria-label": labels.flyoutTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, (toolResults !== null && toolResults !== void 0 ? toolResults : []).map((result, index) => /*#__PURE__*/_react.default.createElement(_thinking_item_layout.ThinkingItemLayout, {
    key: `flyout-result-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_tool_result_display.ToolResultDisplay, {
    toolResult: result,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  })))));
};
exports.RoundSteps = RoundSteps;