"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadingCursorPlugin = exports.Cursor = void 0;
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_response/markdown_plugins/cursor_plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CURSOR = ` ᠎  `;
const loadingCursorPlugin = () => {
  const visitor = (node, parent) => {
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type !== 'text' && node.type !== 'inlineCode' && node.type !== 'code') {
      return;
    }
    const textNode = node;
    const indexOfCursor = textNode.value.indexOf(CURSOR);
    if (indexOfCursor === -1) {
      return;
    }
    textNode.value = textNode.value.replace(CURSOR, '');
    const indexOfNode = parent.children.indexOf(textNode);
    parent.children.splice(indexOfNode + 1, 0, {
      type: 'cursor',
      value: CURSOR
    });
  };
  return tree => {
    visitor(tree);
  };
};
exports.loadingCursorPlugin = loadingCursorPlugin;
const Cursor = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cursorCss = (0, _css.css)`
    @keyframes blink {
      0% {
        opacity: 0;
      }
      50% {
        opacity: 1;
      }
      100% {
        opacity: 0;
      }
    }

    animation: blink 1s infinite;
    width: 10px;
    height: 16px;
    display: inline-block;
    vertical-align: middle;
    background: ${euiTheme.colors.backgroundLightText};
  `;
  return /*#__PURE__*/_react.default.createElement("span", {
    key: "cursor",
    className: (0, _classnames.default)(cursorCss, 'cursor'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 10
    }
  });
};
exports.Cursor = Cursor;