"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundLayout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _round_input = require("./round_input");
var _round_thinking = require("./round_thinking/round_thinking");
var _round_response = require("./round_response/round_response");
var _send_message_context = require("../../../context/send_message/send_message_context");
var _round_error = require("./round_error/round_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  container: _i18n.i18n.translate('xpack.onechat.round.container', {
    defaultMessage: 'Conversation round'
  })
};
const RoundLayout = ({
  isCurrentRound,
  scrollContainerHeight,
  rawRound
}) => {
  const [roundContainerMinHeight, setRoundContainerMinHeight] = (0, _react2.useState)(0);
  const {
    steps,
    response,
    input
  } = rawRound;
  const {
    isResponseLoading,
    error,
    retry: retrySendMessage
  } = (0, _send_message_context.useSendMessage)();
  const isLoadingCurrentRound = isResponseLoading && isCurrentRound;
  const isErrorCurrentRound = Boolean(error) && isCurrentRound;
  (0, _react2.useEffect)(() => {
    // Pending rounds and error rounds should have a min-height to match the scroll container height
    if (isCurrentRound && isResponseLoading || isErrorCurrentRound) {
      setRoundContainerMinHeight(scrollContainerHeight);
    } else {
      setRoundContainerMinHeight(0);
    }
  }, [isCurrentRound, isResponseLoading, scrollContainerHeight, isErrorCurrentRound]);
  const roundContainerStyles = (0, _react.css)`
    ${roundContainerMinHeight > 0 ? `min-height: ${roundContainerMinHeight}px;` : 'flex-grow: 0;'};
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "aria-label": labels.container,
    css: roundContainerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_round_input.RoundInput, {
    input: input.message,
    attachments: input.attachments,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, isErrorCurrentRound ? /*#__PURE__*/_react2.default.createElement(_round_error.RoundError, {
    error: error,
    errorSteps: rawRound.steps,
    onRetry: retrySendMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react2.default.createElement(_round_thinking.RoundThinking, {
    steps: steps,
    isLoading: isLoadingCurrentRound,
    rawRound: rawRound,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_round_response.RoundResponse, {
    hasError: isErrorCurrentRound,
    response: response,
    steps: steps,
    isLoading: isLoadingCurrentRound,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }))));
};
exports.RoundLayout = RoundLayout;