"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationRounds = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_conversation = require("../../../hooks/use_conversation");
var _round_layout = require("./round_layout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/conversation_rounds.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CONVERSATION_ROUNDS_ID = 'onechatConversationRoundsContainer';
const ConversationRounds = ({
  scrollContainerHeight
}) => {
  const conversationRounds = (0, _use_conversation.useConversationRounds)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    id: CONVERSATION_ROUNDS_ID,
    direction: "column",
    gutterSize: "l",
    "aria-label": _i18n.i18n.translate('xpack.onechat.conversationRounds', {
      defaultMessage: 'Conversation messages'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, conversationRounds.map((round, index) => {
    const isCurrentRound = index === conversationRounds.length - 1;
    return /*#__PURE__*/_react.default.createElement(_round_layout.RoundLayout, {
      key: index,
      scrollContainerHeight: scrollContainerHeight,
      isCurrentRound: isCurrentRound,
      rawRound: round,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    });
  }));
};
exports.ConversationRounds = ConversationRounds;