"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentSelector = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _conversation_context = require("../../../../../context/conversation/conversation_context");
var _use_agents = require("../../../../../hooks/agents/use_agents");
var _agent_select_dropdown = require("./agent_select_dropdown");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/input_actions/agent_selector/agent_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentSelector = ({
  agentId
}) => {
  const {
    agents,
    isLoading: isLoadingAgents
  } = (0, _use_agents.useOnechatAgents)();
  const {
    conversationActions
  } = (0, _conversation_context.useConversationContext)();
  const handleAgentChange = newAgentId => {
    conversationActions.setAgentId(newAgentId);
  };
  if (isLoadingAgents || !agentId) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 12
      }
    });
  }
  const currentAgent = agents.find(agent => agent.id === agentId);
  return /*#__PURE__*/_react.default.createElement(_agent_select_dropdown.AgentSelectDropdown, {
    selectedAgent: currentAgent,
    onAgentChange: handleAgentChange,
    agents: agents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
};
exports.AgentSelector = AgentSelector;