"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenameConversationInput = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _onechatBrowser = require("@kbn/onechat-browser");
var _react2 = require("@emotion/react");
var _conversation_context = require("../../../context/conversation/conversation_context");
var _use_conversation_id = require("../../../context/conversation/use_conversation_id");
var _use_conversation = require("../../../hooks/use_conversation");
var _use_toasts = require("../../../hooks/use_toasts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header/rename_conversation_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  inputPlaceholder: _i18n.i18n.translate('xpack.onechat.renameConversationInput.inputPlaceholder', {
    defaultMessage: 'Enter conversation name'
  }),
  inputAriaLabel: _i18n.i18n.translate('xpack.onechat.renameConversationInput.inputAriaLabel', {
    defaultMessage: 'Edit conversation title'
  }),
  renameErrorToast: _i18n.i18n.translate('xpack.onechat.renameConversationInput.renameErrorToast', {
    defaultMessage: 'Failed to rename conversation'
  })
};
const RenameConversationInput = ({
  onCancel
}) => {
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const {
    title
  } = (0, _use_conversation.useConversationTitle)();
  const {
    conversationActions,
    isEmbeddedContext
  } = (0, _conversation_context.useConversationContext)();
  const {
    addErrorToast
  } = (0, _use_toasts.useToasts)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [newTitle, setNewTitle] = (0, _react.useState)(title || '');
  const hasFocusedRef = (0, _react.useRef)(false);
  const INPUT_WIDTH = isEmbeddedContext ? '240px' : '340px';
  const inputWidthStyles = (0, _react2.css)`
    width: ${INPUT_WIDTH};
  `;

  // Callback ref that focuses only on first mount
  const inputRefCallback = (0, _react.useCallback)(el => {
    if (el && !hasFocusedRef.current) {
      hasFocusedRef.current = true;
      // Use requestAnimationFrame to ensure the element is fully mounted
      requestAnimationFrame(() => {
        el.focus();
        el.select();
      });
    }
  }, []);
  const isFormDirty = newTitle.trim() !== (title || '').trim();
  const handleSave = (0, _react.useCallback)(async () => {
    if (!conversationId || !newTitle.trim() || !isFormDirty) {
      return false; // Return false to prevent EUI from exiting edit mode
    }
    setIsLoading(true);
    try {
      await conversationActions.renameConversation(conversationId, newTitle.trim());
      onCancel();
      return true;
    } catch (error) {
      addErrorToast({
        title: labels.renameErrorToast,
        text: (0, _onechatBrowser.formatOnechatErrorMessage)(error)
      });
      return false; // Stay in edit mode on error
    } finally {
      setIsLoading(false);
    }
  }, [conversationId, newTitle, conversationActions, onCancel, isFormDirty, addErrorToast]);
  const handleKeyDown = (0, _react.useCallback)(e => {
    if (e.key === 'Escape') {
      e.preventDefault();
      onCancel();
    }
  }, [onCancel]);
  if (!conversationId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditText, {
    css: inputWidthStyles,
    placeholder: labels.inputPlaceholder,
    size: "s",
    value: newTitle,
    onKeyDown: handleKeyDown,
    inputAriaLabel: labels.inputAriaLabel,
    onSave: handleSave,
    onCancel: onCancel,
    onChange: e => setNewTitle(e.target.value),
    isLoading: isLoading,
    startWithEditOpen: true,
    editModeProps: {
      inputProps: {
        inputRef: inputRefCallback,
        'data-test-subj': 'renameConversationInputField'
      },
      saveButtonProps: {
        isDisabled: !isFormDirty || newTitle.trim() === '',
        'data-test-subj': 'renameConversationSaveButton'
      },
      cancelButtonProps: {
        'data-test-subj': 'renameConversationCancelButton'
      }
    },
    "data-test-subj": "renameConversationInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  });
};
exports.RenameConversationInput = RenameConversationInput;