"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsSearchControls = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18n2 = require("../../../utils/i18n");
var _filter_option_with_matches_badge = require("../../common/filter_option_with_matches_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/edit/tools_search_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ToolsSearchControls = ({
  displayTools,
  searchQuery,
  onSearchChange,
  showActiveOnly,
  onShowActiveOnlyChange,
  disabled
}) => {
  const allTags = _react.default.useMemo(() => {
    const tagsSet = new Set();
    displayTools.forEach(tool => {
      tool.tags.forEach(tag => tagsSet.add(tag));
    });
    return Array.from(tagsSet);
  }, [displayTools]);
  const searchConfig = _react.default.useMemo(() => {
    const matchesByTag = (0, _lodash.countBy)(displayTools.flatMap(tool => tool.tags));
    const config = {
      box: {
        incremental: true,
        placeholder: _i18n2.labels.tools.searchToolsPlaceholder
      },
      filters: [{
        type: 'field_value_selection',
        field: 'tags',
        name: _i18n2.labels.tools.tagsFilter,
        multiSelect: 'or',
        options: allTags.map(tag => {
          var _matchesByTag$tag;
          return {
            value: tag,
            name: tag,
            view: /*#__PURE__*/_react.default.createElement(_filter_option_with_matches_badge.FilterOptionWithMatchesBadge, {
              name: tag,
              matches: (_matchesByTag$tag = matchesByTag[tag]) !== null && _matchesByTag$tag !== void 0 ? _matchesByTag$tag : 0,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 59,
                columnNumber: 19
              }
            })
          };
        }),
        searchThreshold: 1,
        autoSortOptions: false
      }],
      onChange: ({
        queryText,
        error: searchError
      }) => {
        if (searchError) {
          return;
        }
        onSearchChange(queryText);
      },
      query: searchQuery
    };
    return config;
  }, [displayTools, allTags, searchQuery, onSearchChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, Object.keys(searchConfig).length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, (0, _extends2.default)({}, searchConfig, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }))), onShowActiveOnlyChange && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.onechat.tools.showActiveOnly', {
      defaultMessage: 'Show active only'
    }),
    checked: showActiveOnly,
    onChange: e => onShowActiveOnlyChange(e.target.checked),
    disabled: disabled,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  })))));
};
exports.ToolsSearchControls = ToolsSearchControls;