"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeLicensePrompt = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _prompt_layout = require("./prompt_layout");
var _use_onechat_service = require("../../../hooks/use_onechat_service");
var _use_asset_base_path = require("../../../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/access/prompts/upgrade_license_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SUBSCRIPTIONS_LINK = 'https://www.elastic.co/subscriptions';
const UpgradeLicensePrompt = ({
  variant
}) => {
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const {
    navigationService
  } = (0, _use_onechat_service.useOnechatServices)();
  const primaryButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    href: SUBSCRIPTIONS_LINK,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.access.prompt.upgradeLicense.actions.subscriptionPlansButton",
    defaultMessage: "Subscription plans",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }));
  const secondaryButton = navigationService.hasLicenseManagentLocator() ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      navigationService.navigateToLicenseManagementDashboard();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.access.prompt.upgradeLicense.actions.manageLicenseButton",
    defaultMessage: "Manage your license",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  })) : undefined;
  return /*#__PURE__*/_react.default.createElement(_prompt_layout.PromptLayout, {
    variant: variant,
    imageSrc: colorMode === 'LIGHT' ? `${assetBasePath}/lock_light.svg` : `${assetBasePath}/lock_dark.svg`,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.access.prompt.upgradeLicense.title",
      defaultMessage: "Upgrade your cluster license",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.access.prompt.upgradeLicense.description",
      defaultMessage: "Your cluster needs an Enterprise license to use the Elastic Agent Builder.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }),
    primaryButton: primaryButton,
    secondaryButton: secondaryButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
};
exports.UpgradeLicensePrompt = UpgradeLicensePrompt;