"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runAgentStepCommonDefinition = exports.RunAgentStepTypeId = exports.OutputSchema = exports.InputSchema = void 0;
var _v = require("@kbn/zod/v4");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Step type ID for the onechat run agent step.
 */
const RunAgentStepTypeId = exports.RunAgentStepTypeId = 'onechat.runAgent';

/**
 * Input schema for the run agent step.
 */
const InputSchema = exports.InputSchema = _v.z.object({
  /**
   * The ID of the agent to chat with. Defaults to the default Elastic AI agent.
   */
  agent_id: _v.z.string().optional(),
  /**
   * output schema for the run agent step, if provided agent will return structured output
   */
  schema: _v.z.string().optional(),
  /**
   * The user input message to send to the agent.
   */
  message: _v.z.string()
});

/**
 * Output schema for the run agent step.
 */
const OutputSchema = exports.OutputSchema = _v.z.union([_v.z.string(), _v.z.any()]);
/**
 * Common step definition for RunAgent step.
 * This is shared between server and public implementations.
 * Input and output types are automatically inferred from the schemas.
 */
const runAgentStepCommonDefinition = exports.runAgentStepCommonDefinition = {
  id: RunAgentStepTypeId,
  inputSchema: InputSchema,
  outputSchema: OutputSchema
};