"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.docLinks = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AgentBuilderDocLinks {
  constructor() {
    (0, _defineProperty2.default)(this, "agentBuilder", '');
    (0, _defineProperty2.default)(this, "getStarted", '');
    (0, _defineProperty2.default)(this, "models", '');
    (0, _defineProperty2.default)(this, "chat", '');
    (0, _defineProperty2.default)(this, "agentBuilderAgents", '');
    (0, _defineProperty2.default)(this, "tools", '');
    (0, _defineProperty2.default)(this, "programmaticAccess", '');
    (0, _defineProperty2.default)(this, "kibanaApi", '');
    (0, _defineProperty2.default)(this, "mcpServer", '');
    (0, _defineProperty2.default)(this, "a2aServer", '');
    (0, _defineProperty2.default)(this, "limitationsKnownIssues", '');
    (0, _defineProperty2.default)(this, "limitationsKnownIssuesConversationLengthExceeded", '');
  }
  setDocLinks(newDocLinks) {
    this.agentBuilder = newDocLinks.agentBuilder.agentBuilder;
    this.getStarted = newDocLinks.agentBuilder.getStarted;
    this.models = newDocLinks.agentBuilder.models;
    this.chat = newDocLinks.agentBuilder.chat;
    this.agentBuilderAgents = newDocLinks.agentBuilder.agentBuilderAgents;
    this.tools = newDocLinks.agentBuilder.tools;
    this.programmaticAccess = newDocLinks.agentBuilder.programmaticAccess;
    this.kibanaApi = newDocLinks.agentBuilder.kibanaApi;
    this.mcpServer = newDocLinks.agentBuilder.mcpServer;
    this.a2aServer = newDocLinks.agentBuilder.a2aServer;
    this.limitationsKnownIssues = newDocLinks.agentBuilder.limitationsKnownIssues;
    this.limitationsKnownIssuesConversationLengthExceeded = `${newDocLinks.agentBuilder.limitationsKnownIssues}#conversation-length-exceeded`;
  }
}
const docLinks = exports.docLinks = new AgentBuilderDocLinks();