"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanPrompt = void 0;
var _dedent = _interopRequireDefault(require("dedent"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Clean up a template string prompt by removing extra newlines and whitespace.
 */
const cleanPrompt = prompt => {
  return (0, _dedent.default)(prompt).replace(/(\r?\n\s*){2,}/g, '\n\n');
};
exports.cleanPrompt = cleanPrompt;