"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsForEntity = getAlertsForEntity;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _kql_query = require("../../es/queries/kql_query");
var _range_query = require("../../es/queries/range_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAlertsForEntity({
  start,
  end,
  entity,
  alertsClient,
  rulesClient,
  size
}) {
  const alertsKuery = Object.entries(entity).map(([field, value]) => {
    return `(${[`(${_ruleDataUtils.ALERT_GROUP_FIELD}:"${field}" AND ${_ruleDataUtils.ALERT_GROUP_VALUE}:"${value}")`, `(${field}:"${value}")`].join(' OR ')})`;
  }).join(' AND ');
  const openAlerts = await alertsClient.find({
    size,
    query: {
      bool: {
        filter: [...(0, _kql_query.kqlQuery)(alertsKuery), ...(0, _range_query.rangeQuery)(start, end, _ruleDataUtils.ALERT_TIME_RANGE), {
          term: {
            [_ruleDataUtils.ALERT_STATUS]: _ruleDataUtils.ALERT_STATUS_ACTIVE
          }
        }]
      }
    }
  });
  return openAlerts;
}