"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergePlainObjects = mergePlainObjects;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const customMergeFunction = (value, sourceValue) => {
  if ((0, _lodash.isPlainObject)(sourceValue)) {
    return (0, _lodash.mergeWith)(value, sourceValue, customMergeFunction);
  }
  return sourceValue;
};
function mergePlainObjectsOnly(...sources) {
  return (0, _lodash.mergeWith)({}, ...sources.concat(customMergeFunction));
}
/**
 * Merges plain objects. It does two things over merge:
 *
 * - it expects the objects to be extensions of the type of
 * the source object, to provide type autocompletions
 * - arrays are not merged but overridden
 *
 * @param sources
 * @returns
 */
function mergePlainObjects(...sources) {
  const merged = mergePlainObjectsOnly(...sources);
  return merged;
}