"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertTitle = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertTitle = ruleCategory => {
  return _i18n.i18n.translate('xpack.observability.alertDetails.title', {
    defaultMessage: '{ruleCategory} {ruleCategory, select, Anomaly {detected} Inventory {threshold breached} other {breached}}',
    values: {
      ruleCategory
    }
  });
};
exports.getAlertTitle = getAlertTitle;