"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPaletteFlexItem = ColorPaletteFlexItem;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/components/sections/ux/core_web_vitals/color_palette_flex_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ColoredSpan = _styledComponents.default.div`
  height: 16px;
  width: 100%;
  cursor: pointer;
`;
const getSpanStyle = (position, inFocus, hexCode, percentage) => {
  let first = position === 0 || percentage === 100;
  let last = position === 2 || percentage === 100;
  if (percentage === 100) {
    first = true;
    last = true;
  }
  const spanStyle = {
    backgroundColor: hexCode,
    opacity: !inFocus ? 1 : 0.3
  };
  let borderRadius = '';
  if (first) {
    borderRadius = '4px 0 0 4px';
  }
  if (last) {
    borderRadius = '0 4px 4px 0';
  }
  if (first && last) {
    borderRadius = '4px';
  }
  spanStyle.borderRadius = borderRadius;
  return spanStyle;
};
function ColorPaletteFlexItem({
  hexCode,
  inFocus,
  percentage,
  tooltip,
  position
}) {
  const spanStyle = getSpanStyle(position, inFocus, hexCode, percentage);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: hexCode,
    grow: false,
    style: {
      width: percentage + '%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltip,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ColoredSpan, {
    style: spanStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  })));
}