"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeBoolQueries = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mergeBoolQueries = (firstQuery, secondQuery) => {
  const first = firstQuery.bool;
  const second = secondQuery.bool;
  return {
    bool: {
      must: [...first.must, ...second.must],
      must_not: [...first.must_not, ...second.must_not],
      filter: [...first.filter, ...second.filter],
      should: [...first.should, ...second.should]
    }
  };
};
exports.mergeBoolQueries = mergeBoolQueries;