"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteRules = useDeleteRules;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/alerting-plugin/common");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDeleteRules() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const deleteRules = (0, _reactQuery.useMutation)(['deleteRules'], ({
    ids,
    filter
  }) => {
    try {
      const body = JSON.stringify({
        ...(ids !== null && ids !== void 0 && ids.length ? {
          ids
        } : {}),
        ...(filter ? {
          filter: JSON.stringify(filter)
        } : {})
      });
      return http.patch(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/rules/_bulk_delete`, {
        body
      });
    } catch (e) {
      throw new Error(`Unable to parse bulk delete params: ${e}`);
    }
  }, {
    onError: (_err, rule, context) => {
      toasts.addDanger(_i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.errorNotification.descriptionText', {
        defaultMessage: 'Failed to delete rule'
      }));
    },
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observability.rules.deleteConfirmationModal.successNotification.descriptionText', {
        defaultMessage: 'Deleted rule'
      }));
    }
  });
  return deleteRules;
}