"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAppLink = useAppLink;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_slo_link_data = require("./get_link_data/get_slo_link_data");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const viewLinkedObjectSupportedRuleTypes = [_ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID];
const isViewLinkedObjectSupportedRuleType = ruleTypeId => {
  return ruleTypeId !== undefined && Object.values(viewLinkedObjectSupportedRuleTypes).includes(ruleTypeId);
};
const getLocatorParamsMap = {
  [_ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID]: _get_slo_link_data.getSLOLinkData
};
function useAppLink({
  rule
}) {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    share: {
      url: {
        locators
      }
    }
  } = services;
  const {
    urlParams,
    buttonText,
    locatorId
  } = isViewLinkedObjectSupportedRuleType(rule === null || rule === void 0 ? void 0 : rule.ruleTypeId) ? getLocatorParamsMap[rule.ruleTypeId](rule) : {
    urlParams: undefined,
    buttonText: '',
    locatorId: ''
  };
  const locator = locators.get(locatorId);
  if (urlParams && locator) {
    return {
      linkUrl: locator.getRedirectUrl(urlParams),
      buttonText
    };
  }
  return {
    linkUrl: null,
    buttonText: ''
  };
}