"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggregationsByGroupingField = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAggregationsByGroupingField = field => {
  switch (field) {
    case _ruleDataUtils.ALERT_RULE_NAME:
      return [{
        sourceCountAggregation: {
          cardinality: {
            field: _ruleDataUtils.ALERT_INSTANCE_ID
          }
        }
      }, {
        ruleTags: {
          terms: {
            field: 'tags'
          }
        }
      }];
      break;
    case _ruleDataUtils.ALERT_INSTANCE_ID:
      return [{
        rulesCountAggregation: {
          cardinality: {
            field: _ruleDataUtils.ALERT_RULE_UUID
          }
        }
      }];
      break;
    default:
      return [{
        rulesCountAggregation: {
          cardinality: {
            field: _ruleDataUtils.ALERT_RULE_UUID
          }
        }
      }];
  }
};
exports.getAggregationsByGroupingField = getAggregationsByGroupingField;