"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedOtlpCallout = ManagedOtlpCallout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_managed_otlp_service_tech_preview_visibility = require("../../shared/use_managed_otlp_service_tech_preview_visibility");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/shared/managed_otlp_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ManagedOtlpCallout() {
  const isTechnicalPreview = (0, _use_managed_otlp_service_tech_preview_visibility.useManagedOtlpServiceTechPreviewVisibility)();
  if (!isTechnicalPreview) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: managedOtlpCalloutTitleText,
    iconType: "info",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.managedOtlpCallout.description",
    defaultMessage: "Managed OTLP Endpoint should not be used in production yet for Elastic Cloud Hosted deployments. For more details, refer to the {motlpDocumentation}.",
    values: {
      motlpDocumentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "observabilityOnboardingManagedOtlpCalloutDocsLink",
        target: "_blank",
        href: "https://www.elastic.co/docs/reference/opentelemetry/motlp",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 17
        }
      }, managedOtlpDocumentationLinkLabelText)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
}
const managedOtlpCalloutTitleText = _i18n.i18n.translate('xpack.observability_onboarding.managedOtlpCallout.title', {
  defaultMessage: 'Managed OTLP Endpoint is in Tech Preview for Elastic Cloud Hosted'
});
const managedOtlpDocumentationLinkLabelText = _i18n.i18n.translate('xpack.observability_onboarding.managedOtlpCallout.documentationLinkLabel', {
  defaultMessage: 'Managed OTLP Endpoint documentation'
});